/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class FileCopy {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File from, File to, boolean force) throws IOException, FileExistsException {
        if (from == null || to == null) {
            throw new IOException("source or target is null");
        }
        if (!from.canRead()) {
            throw new IOException("read permission failed in " + from.getAbsolutePath());
        }
        if (to.isDirectory() && !to.exists()) {
            throw new IOException("target directory " + to.getAbsolutePath() + " does not exist");
        }
        if (to.isFile() && to.exists() && !to.canWrite()) {
            throw new IOException("write permission failed in " + to.getAbsolutePath());
        }
        if (to.isFile() && to.exists() && !force) {
            throw new FileExistsException("file " + to.getAbsolutePath() + " allready exists");
        }
        if (to.isDirectory()) {
            to = new File(to, from.getName());
        }
        FileChannel srcChannel = null;
        AbstractInterruptibleChannel dstChannel = null;
        try {
            srcChannel = new FileInputStream(from).getChannel();
            dstChannel = new FileOutputStream(to).getChannel();
            ((FileChannel)dstChannel).transferFrom(srcChannel, 0L, srcChannel.size());
        }
        finally {
            try {
                if (srcChannel != null) {
                    srcChannel.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (dstChannel != null) {
                    dstChannel.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static class FileExistsException
    extends Exception {
        public FileExistsException(String message) {
            super(message);
        }
    }
}

